/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Scanner;
import org.dynmap.Color;
import org.dynmap.DynmapCore;
import org.dynmap.Log;
import org.dynmap.MapManager;
import org.dynmap.common.BiomeMap;
import org.dynmap.debug.Debug;

public class ColorScheme {
    private static final HashMap<String, ColorScheme> cache = new HashMap();
    public String name;
    public Color[][] colors;
    public Color[][][] datacolors;
    public final Color[][] biomecolors;
    public final Color[][] raincolors;
    public final Color[][] tempcolors;

    public ColorScheme(String name, Color[][] colors, Color[][][] datacolors, Color[][] biomecolors, Color[][] raincolors, Color[][] tempcolors) {
        this.name = name;
        this.colors = colors;
        this.datacolors = datacolors;
        this.biomecolors = biomecolors;
        this.raincolors = raincolors;
        this.tempcolors = tempcolors;
        for (int i = 0; i < colors.length; ++i) {
            int id = MapManager.mapman.getBlockIDAlias(i);
            if (id == i) continue;
            this.colors[i] = this.colors[id];
            this.datacolors[i] = this.datacolors[id];
        }
    }

    private static File getColorSchemeDirectory(DynmapCore core) {
        return new File(core.getDataFolder(), "colorschemes");
    }

    public static ColorScheme getScheme(DynmapCore core, String name) {
        ColorScheme scheme;
        if (name == null) {
            name = "default";
        }
        if ((scheme = cache.get(name)) == null) {
            scheme = ColorScheme.loadScheme(core, name);
            cache.put(name, scheme);
        }
        return scheme;
    }

    public static ColorScheme loadScheme(DynmapCore core, String name) {
        File colorSchemeFile = new File(ColorScheme.getColorSchemeDirectory(core), name + ".txt");
        Color[][] colors = new Color[4096][];
        Color[][][] datacolors = new Color[4096][][];
        Color[][] biomecolors = new Color[BiomeMap.values().length][];
        Color[][] raincolors = new Color[64][];
        Color[][] tempcolors = new Color[64][];
        for (int i = 0; i < biomecolors.length; ++i) {
            Color[] c = new Color[5];
            int red = 0x80 | 64 * (i >> 0 & 1) | 32 * (i >> 3 & 1) | 16 * (i >> 6 & 1);
            int green = 0x80 | 64 * (i >> 1 & 1) | 32 * (i >> 4 & 1) | 16 * (i >> 7 & 1);
            int blue = 0x80 | 64 * (i >> 2 & 1) | 32 * (i >> 5 & 1);
            c[0] = new Color(red, green, blue);
            c[3] = new Color(red * 4 / 5, green * 4 / 5, blue * 4 / 5);
            c[1] = new Color(red / 2, green / 2, blue / 2);
            c[2] = new Color(red * 2 / 5, green * 2 / 5, blue * 2 / 5);
            c[4] = new Color((c[1].getRed() + c[3].getRed()) / 2, (c[1].getGreen() + c[3].getGreen()) / 2, (c[1].getBlue() + c[3].getBlue()) / 2, (c[1].getAlpha() + c[3].getAlpha()) / 2);
            biomecolors[i] = c;
        }
        try {
            Debug.debug("Loading colors from '" + colorSchemeFile + "'...");
            FileInputStream stream = new FileInputStream(colorSchemeFile);
            Scanner scanner = new Scanner(stream);
            while (scanner.hasNextLine()) {
                Integer id;
                String line = scanner.nextLine();
                if (line.startsWith("#") || line.equals("")) continue;
                String[] split = line.split("[\t ]");
                int cnt = 0;
                for (String s : split) {
                    if (s.length() <= 0) continue;
                    ++cnt;
                }
                String[] nsplit = new String[cnt];
                cnt = 0;
                for (String s : split) {
                    if (s.length() <= 0) continue;
                    nsplit[cnt] = s;
                    ++cnt;
                }
                split = nsplit;
                if (split.length < 17) continue;
                Integer dat = null;
                boolean isbiome = false;
                boolean istemp = false;
                boolean israin = false;
                int idx = split[0].indexOf(58);
                if (idx > 0) {
                    id = new Integer(split[0].substring(0, idx));
                    dat = new Integer(split[0].substring(idx + 1));
                } else if (split[0].charAt(0) == '[') {
                    String bio = split[0].substring(1);
                    idx = bio.indexOf(93);
                    if (idx >= 0) {
                        bio = bio.substring(0, idx);
                    }
                    isbiome = true;
                    id = -1;
                    BiomeMap[] bm = BiomeMap.values();
                    for (int i = 0; i < bm.length; ++i) {
                        if (bm[i].toString().equalsIgnoreCase(bio)) {
                            id = i;
                            break;
                        }
                        if (!bio.equalsIgnoreCase("BIOME_" + i)) continue;
                        id = i;
                        break;
                    }
                    if (id < 0) {
                        double v;
                        if (bio.startsWith("RAINFALL-")) {
                            try {
                                v = Double.parseDouble(bio.substring(9));
                                if (v >= 0.0 && v <= 1.0) {
                                    id = (int)(v * 63.0);
                                    israin = true;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else if (bio.startsWith("TEMPERATURE-")) {
                            try {
                                v = Double.parseDouble(bio.substring(12));
                                if (v >= 0.0 && v <= 1.0) {
                                    id = (int)(v * 63.0);
                                    istemp = true;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    }
                } else {
                    id = new Integer(split[0]);
                }
                if (!isbiome && id >= colors.length) {
                    Color[][] newcolors = new Color[id + 1][];
                    System.arraycopy(colors, 0, newcolors, 0, colors.length);
                    colors = newcolors;
                    Color[][][] newdatacolors = new Color[id + 1][][];
                    System.arraycopy(datacolors, 0, newdatacolors, 0, datacolors.length);
                    datacolors = newdatacolors;
                }
                Color[] c = new Color[5];
                c[0] = new Color(Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Integer.parseInt(split[4]));
                c[3] = new Color(Integer.parseInt(split[5]), Integer.parseInt(split[6]), Integer.parseInt(split[7]), Integer.parseInt(split[8]));
                c[1] = new Color(Integer.parseInt(split[9]), Integer.parseInt(split[10]), Integer.parseInt(split[11]), Integer.parseInt(split[12]));
                c[2] = new Color(Integer.parseInt(split[13]), Integer.parseInt(split[14]), Integer.parseInt(split[15]), Integer.parseInt(split[16]));
                c[4] = new Color((c[1].getRed() + c[3].getRed()) / 2, (c[1].getGreen() + c[3].getGreen()) / 2, (c[1].getBlue() + c[3].getBlue()) / 2, (c[1].getAlpha() + c[3].getAlpha()) / 2);
                if (isbiome) {
                    if (istemp) {
                        tempcolors[id.intValue()] = c;
                        continue;
                    }
                    if (israin) {
                        raincolors[id.intValue()] = c;
                        continue;
                    }
                    if (id < 0 || id >= biomecolors.length) continue;
                    biomecolors[id.intValue()] = c;
                    continue;
                }
                if (dat != null) {
                    Color[][] dcolor = datacolors[id];
                    if (dcolor == null) {
                        dcolor = new Color[16][];
                        datacolors[id.intValue()] = dcolor;
                    }
                    if (dat >= 0 && dat < 16) {
                        dcolor[dat.intValue()] = c;
                    }
                    if (dat != 0) continue;
                    colors[id.intValue()] = c;
                    continue;
                }
                colors[id.intValue()] = c;
            }
            scanner.close();
            for (int k = 0; k < datacolors.length; ++k) {
                Color[][] dc = datacolors[k];
                if (dc == null) continue;
                Color[] c = colors[k];
                for (int i = 0; i < 16; ++i) {
                    if (dc[i] != null) continue;
                    dc[i] = c;
                }
            }
            ColorScheme.interpolateColorTable(tempcolors);
            ColorScheme.interpolateColorTable(raincolors);
        }
        catch (RuntimeException e) {
            Log.severe("Could not load colors '" + name + "' ('" + colorSchemeFile + "').", e);
            return null;
        }
        catch (FileNotFoundException e) {
            Log.severe("Could not load colors '" + name + "' ('" + colorSchemeFile + "'): File not found.", e);
        }
        return new ColorScheme(name, colors, datacolors, biomecolors, raincolors, tempcolors);
    }

    public static void interpolateColorTable(Color[][] c) {
        int idx = -1;
        for (int k = 0; k < c.length; ++k) {
            int kk;
            if (c[k] == null) {
                if (idx < 0 || k != c.length - 1) continue;
                for (kk = idx + 1; kk <= k; ++kk) {
                    c[kk] = c[idx];
                }
                continue;
            }
            if (idx == -1) {
                for (kk = 0; kk < k; ++kk) {
                    c[kk] = c[k];
                }
                idx = k;
                continue;
            }
            int cnt = c[k].length;
            for (int kk2 = idx + 1; kk2 < k; ++kk2) {
                double interp = (double)(kk2 - idx) / (double)(k - idx);
                Color[] cc = new Color[cnt];
                for (int jj = 0; jj < cnt; ++jj) {
                    cc[jj] = new Color((int)((1.0 - interp) * (double)c[idx][jj].getRed() + interp * (double)c[k][jj].getRed()), (int)((1.0 - interp) * (double)c[idx][jj].getGreen() + interp * (double)c[k][jj].getGreen()), (int)((1.0 - interp) * (double)c[idx][jj].getBlue() + interp * (double)c[k][jj].getBlue()), (int)((1.0 - interp) * (double)c[idx][jj].getAlpha() + interp * (double)c[k][jj].getAlpha()));
                }
                c[kk2] = cc;
            }
            idx = k;
        }
    }

    public Color[] getRainColor(double rain) {
        int idx = (int)(rain * 63.0);
        if (idx >= 0 && idx < this.raincolors.length) {
            return this.raincolors[idx];
        }
        return null;
    }

    public Color[] getTempColor(double temp) {
        int idx = (int)(temp * 63.0);
        if (idx >= 0 && idx < this.tempcolors.length) {
            return this.tempcolors[idx];
        }
        return null;
    }

    public void resizeColorArray(int idx) {
        if (idx >= this.colors.length) {
            Color[][] newcolors = new Color[idx + 1][];
            System.arraycopy(this.colors, 0, newcolors, 0, this.colors.length);
            this.colors = newcolors;
            Color[][][] newdatacolors = new Color[idx + 1][][];
            System.arraycopy(this.datacolors, 0, newdatacolors, 0, this.datacolors.length);
            this.datacolors = newdatacolors;
        }
    }

    public static void reset() {
        cache.clear();
    }
}

