/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Server;
import org.bukkit.World;
import org.dynmap.Log;
import org.dynmap.bukkit.BukkitVersionHelperGeneric;
import org.dynmap.bukkit.DynmapPlugin;
import org.dynmap.hdmap.HDBlockModels;
import org.dynmap.utils.Polygon;

public class BukkitVersionHelperCB
extends BukkitVersionHelperGeneric {
    private Class<?> nmsblock;
    private Class<?> nmsblockarray;
    private Class<?> nmsmaterial;
    private Field blockbyid;
    private Field blockname;
    private Field material;
    private Method blockbyidfunc;
    private Method getworldborder;
    private Class<?> nmsworldborder;
    private Method worldborderminx;
    private Method worldbordermaxx;
    private Method worldborderminz;
    private Method worldbordermaxz;
    private Method getbiomebyid;
    private Method getidbybiome;
    private boolean isBadUnload = false;
    private Object[] biomelist = null;

    BukkitVersionHelperCB() {
        String bukkitver = DynmapPlugin.plugin.getServer().getVersion();
        String mcver = "1.0.0";
        int idx = bukkitver.indexOf("(MC: ");
        if (idx > 0 && (idx = (mcver = bukkitver.substring(idx + 5)).indexOf(")")) > 0) {
            mcver = mcver.substring(0, idx);
        }
        this.isBadUnload = HDBlockModels.checkVersionRange(mcver, "1.9-");
        Log.verboseinfo("MCVER=" + mcver + ", isBadUnload=" + this.isBadUnload);
    }

    @Override
    protected String getNMSPackage() {
        Server srv = Bukkit.getServer();
        try {
            Method m = srv.getClass().getMethod("getHandle", new Class[0]);
            Object scm = m.invoke((Object)srv, new Object[0]);
            return scm.getClass().getPackage().getName();
        }
        catch (Exception x) {
            Log.severe("Error finding net.minecraft.server packages");
            return null;
        }
    }

    @Override
    protected void loadNMS() {
        this.nmsblock = this.getNMSClass("net.minecraft.server.Block");
        this.nmsblockarray = this.getNMSClass("[Lnet.minecraft.server.Block;");
        this.nmsmaterial = this.getNMSClass("net.minecraft.server.Material");
        this.blockbyid = this.getFieldNoFail(this.nmsblock, new String[]{"byId"}, this.nmsblockarray);
        if (this.blockbyid == null) {
            this.blockbyidfunc = this.getMethod(this.nmsblock, new String[]{"getById", "e"}, new Class[]{Integer.TYPE});
        }
        this.blockname = this.getPrivateField(this.nmsblock, new String[]{"name", "b"}, String.class);
        this.material = this.getPrivateField(this.nmsblock, new String[]{"material"}, this.nmsmaterial);
        this.biomebase = this.getNMSClass("net.minecraft.server.BiomeBase");
        this.biomebasearray = this.getNMSClass("[Lnet.minecraft.server.BiomeBase;");
        this.biomebaselist = this.getPrivateFieldNoFail(this.biomebase, new String[]{"biomes"}, this.biomebasearray);
        if (this.biomebaselist == null) {
            this.getbiomebyid = this.getMethod(this.biomebase, new String[]{"a"}, new Class[]{Integer.TYPE});
        }
        this.biomebasetemp = this.getPrivateFieldNoFail(this.biomebase, new String[]{"B"}, Float.TYPE);
        if (this.biomebasetemp != null) {
            this.biomebasehumi = this.getPrivateField(this.biomebase, new String[]{"C"}, Float.TYPE);
        } else {
            this.biomebasetemp = this.getPrivateField(this.biomebase, new String[]{"temperature", "F", "C"}, Float.TYPE);
            this.biomebasehumi = this.getPrivateField(this.biomebase, new String[]{"humidity", "G", "D"}, Float.TYPE);
        }
        this.biomebaseidstring = this.getPrivateField(this.biomebase, new String[]{"y", "af", "ah", "z"}, String.class);
        this.biomebaseid = this.getFieldNoFail(this.biomebase, new String[]{"id"}, Integer.TYPE);
        if (this.biomebaseid == null) {
            this.getidbybiome = this.getMethod(this.biomebase, new String[]{"a"}, new Class[]{this.biomebase});
        }
        this.nmsworld = this.getNMSClass("net.minecraft.server.WorldServer");
        this.chunkprovserver = this.getNMSClass("net.minecraft.server.ChunkProviderServer");
        this.nmsw_chunkproviderserver = this.getPrivateFieldNoFail(this.nmsworld, new String[]{"chunkProviderServer"}, this.chunkprovserver);
        if (this.nmsw_chunkproviderserver == null) {
            Class<?> nmsworldbase = this.getNMSClass("net.minecraft.server.World");
            Class<?> nmsichunkprovider = this.getNMSClass("net.minecraft.server.IChunkProvider");
            this.nmsw_chunkproviderserver = this.getPrivateField(nmsworldbase, new String[]{"chunkProvider"}, nmsichunkprovider);
        }
        this.getworldborder = this.getMethodNoFail(this.nmsworld, new String[]{"af"}, nulltypes);
        this.longhashset = this.getOBCClassNoFail("org.bukkit.craftbukkit.util.LongHashSet");
        if (this.longhashset != null) {
            this.lhs_containskey = this.getMethod(this.longhashset, new String[]{"contains"}, new Class[]{Integer.TYPE, Integer.TYPE});
        } else {
            this.longhashset = this.getOBCClassNoFail("org.bukkit.craftbukkit.util.LongHashset");
            if (this.longhashset != null) {
                this.lhs_containskey = this.getMethod(this.longhashset, new String[]{"containsKey"}, new Class[]{Integer.TYPE, Integer.TYPE});
            }
        }
        this.cps_unloadqueue_isSet = false;
        if (this.longhashset != null) {
            this.cps_unloadqueue = this.getFieldNoFail(this.chunkprovserver, new String[]{"unloadQueue"}, this.longhashset);
        }
        if (this.cps_unloadqueue == null) {
            this.cps_unloadqueue = this.getFieldNoFail(this.chunkprovserver, new String[]{"unloadQueue"}, Set.class);
            this.cps_unloadqueue_isSet = true;
        }
        if (this.cps_unloadqueue == null) {
            Log.info("Unload queue not found - default to unload all chunks");
        }
        this.nmschunk = this.getNMSClass("net.minecraft.server.Chunk");
        this.nmsc_tileentities = this.getField(this.nmschunk, new String[]{"tileEntities"}, Map.class);
        this.nmsc_inhabitedticks = this.getPrivateFieldNoFail(this.nmschunk, new String[]{"s", "q", "u", "v", "w"}, Long.TYPE);
        if (this.nmsc_inhabitedticks == null) {
            Log.info("inhabitedTicks field not found - inhabited shader not functional");
        }
        this.nmsworldborder = this.getNMSClassNoFail("net.minecraft.server.WorldBorder");
        if (this.nmsworldborder != null) {
            this.worldborderminx = this.getMethod(this.nmsworldborder, new String[]{"b"}, nulltypes);
            this.worldborderminz = this.getMethod(this.nmsworldborder, new String[]{"c"}, nulltypes);
            this.worldbordermaxx = this.getMethod(this.nmsworldborder, new String[]{"d"}, nulltypes);
            this.worldbordermaxz = this.getMethod(this.nmsworldborder, new String[]{"e"}, nulltypes);
        }
        this.nbttagcompound = this.getNMSClass("net.minecraft.server.NBTTagCompound");
        this.nbttagbyte = this.getNMSClass("net.minecraft.server.NBTTagByte");
        this.nbttagshort = this.getNMSClass("net.minecraft.server.NBTTagShort");
        this.nbttagint = this.getNMSClass("net.minecraft.server.NBTTagInt");
        this.nbttaglong = this.getNMSClass("net.minecraft.server.NBTTagLong");
        this.nbttagfloat = this.getNMSClass("net.minecraft.server.NBTTagFloat");
        this.nbttagdouble = this.getNMSClass("net.minecraft.server.NBTTagDouble");
        this.nbttagbytearray = this.getNMSClass("net.minecraft.server.NBTTagByteArray");
        this.nbttagstring = this.getNMSClass("net.minecraft.server.NBTTagString");
        this.nbttagintarray = this.getNMSClass("net.minecraft.server.NBTTagIntArray");
        this.compound_get = this.getMethod(this.nbttagcompound, new String[]{"get"}, new Class[]{String.class});
        this.nbttagbyte_val = this.getPrivateField(this.nbttagbyte, new String[]{"data"}, Byte.TYPE);
        this.nbttagshort_val = this.getPrivateField(this.nbttagshort, new String[]{"data"}, Short.TYPE);
        this.nbttagint_val = this.getPrivateField(this.nbttagint, new String[]{"data"}, Integer.TYPE);
        this.nbttaglong_val = this.getPrivateField(this.nbttaglong, new String[]{"data"}, Long.TYPE);
        this.nbttagfloat_val = this.getPrivateField(this.nbttagfloat, new String[]{"data"}, Float.TYPE);
        this.nbttagdouble_val = this.getPrivateField(this.nbttagdouble, new String[]{"data"}, Double.TYPE);
        this.nbttagbytearray_val = this.getPrivateField(this.nbttagbytearray, new String[]{"data"}, byte[].class);
        this.nbttagstring_val = this.getPrivateField(this.nbttagstring, new String[]{"data"}, String.class);
        this.nbttagintarray_val = this.getPrivateField(this.nbttagintarray, new String[]{"data"}, int[].class);
        this.nms_tileentity = this.getNMSClass("net.minecraft.server.TileEntity");
        this.nmst_readnbt = this.getMethod(this.nms_tileentity, new String[]{"b", "save"}, new Class[]{this.nbttagcompound});
        this.nmst_getposition = this.getMethodNoFail(this.nms_tileentity, new String[]{"getPosition"}, new Class[0]);
        if (this.nmst_getposition == null) {
            this.nmst_x = this.getField(this.nms_tileentity, new String[]{"x"}, Integer.TYPE);
            this.nmst_y = this.getField(this.nms_tileentity, new String[]{"y"}, Integer.TYPE);
            this.nmst_z = this.getField(this.nms_tileentity, new String[]{"z"}, Integer.TYPE);
        } else {
            this.nms_blockposition = this.getNMSClass("net.minecraft.server.BlockPosition");
            this.nmsbp_getx = this.getMethod(this.nms_blockposition, new String[]{"getX"}, new Class[0]);
            this.nmsbp_gety = this.getMethod(this.nms_blockposition, new String[]{"getY"}, new Class[0]);
            this.nmsbp_getz = this.getMethod(this.nms_blockposition, new String[]{"getZ"}, new Class[0]);
        }
    }

    @Override
    public void unloadChunkNoSave(World w, Chunk c, int cx, int cz) {
        w.unloadChunk(cx, cz, false, false);
    }

    @Override
    public String[] getBlockShortNames() {
        try {
            String[] names = new String[4096];
            if (this.blockbyid != null) {
                Object[] byid = (Object[])this.blockbyid.get(this.nmsblock);
                for (int i = 0; i < names.length; ++i) {
                    if (byid[i] == null) continue;
                    names[i] = (String)this.blockname.get(byid[i]);
                }
            } else {
                for (int i = 0; i < names.length; ++i) {
                    Object blk = this.blockbyidfunc.invoke(this.nmsblock, i);
                    if (blk == null) continue;
                    names[i] = (String)this.blockname.get(blk);
                }
            }
            return names;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return new String[0];
    }

    @Override
    public String[] getBiomeNames() {
        Object[] biomelist = this.getBiomeBaseList();
        String[] names = new String[biomelist.length];
        for (int i = 0; i < biomelist.length; ++i) {
            Object bb = biomelist[i];
            if (bb == null) continue;
            names[i] = this.getBiomeBaseIDString(bb);
        }
        return names;
    }

    @Override
    public int[] getBlockMaterialMap() {
        try {
            int[] map = new int[4096];
            if (this.blockbyid != null) {
                Object[] byid = (Object[])this.blockbyid.get(this.nmsblock);
                ArrayList<Object> mats = new ArrayList<Object>();
                for (int i = 0; i < map.length; ++i) {
                    if (byid[i] == null) continue;
                    Object mat = this.material.get(byid[i]);
                    if (mat != null) {
                        map[i] = mats.indexOf(mat);
                        if (map[i] >= 0) continue;
                        map[i] = mats.size();
                        mats.add(mat);
                        continue;
                    }
                    map[i] = -1;
                }
            } else {
                ArrayList<Object> mats = new ArrayList<Object>();
                for (int i = 0; i < map.length; ++i) {
                    Object blk = this.blockbyidfunc.invoke(this.nmsblock, i);
                    if (blk == null) continue;
                    Object mat = this.material.get(blk);
                    if (mat != null) {
                        map[i] = mats.indexOf(mat);
                        if (map[i] >= 0) continue;
                        map[i] = mats.size();
                        mats.add(mat);
                        continue;
                    }
                    map[i] = -1;
                }
            }
            return map;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return new int[0];
    }

    @Override
    public Polygon getWorldBorder(World world) {
        Polygon p = null;
        if (this.getworldborder == null || world == null) {
            return null;
        }
        Object cw = this.getNMSWorld(world);
        if (cw == null) {
            return null;
        }
        Object wb = this.callMethod(cw, this.getworldborder, nullargs, null);
        if (wb != null) {
            double minx = (Double)this.callMethod(wb, this.worldborderminx, nullargs, Double.MIN_VALUE);
            double minz = (Double)this.callMethod(wb, this.worldborderminz, nullargs, Double.MIN_VALUE);
            double maxx = (Double)this.callMethod(wb, this.worldbordermaxx, nullargs, Double.MAX_VALUE);
            double maxz = (Double)this.callMethod(wb, this.worldbordermaxz, nullargs, Double.MAX_VALUE);
            if (maxx < 1.0E7) {
                p = new Polygon();
                p.addVertex(minx, minz);
                p.addVertex(minx, maxz);
                p.addVertex(maxx, maxz);
                p.addVertex(maxx, minz);
            }
        }
        return p;
    }

    @Override
    public Object[] getBiomeBaseList() {
        if (this.getbiomebyid != null) {
            if (this.biomelist == null) {
                this.biomelist = new Object[1024];
                for (int i = 0; i < 1024; ++i) {
                    try {
                        this.biomelist[i] = this.getbiomebyid.invoke((Object)this.biomebase, i);
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        continue;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
            }
            return this.biomelist;
        }
        return super.getBiomeBaseList();
    }

    @Override
    public int getBiomeBaseID(Object bb) {
        if (this.getidbybiome != null) {
            try {
                return (Integer)this.getidbybiome.invoke((Object)this.biomebase, bb);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return super.getBiomeBaseID(bb);
    }

    @Override
    public boolean isUnloadChunkBroken() {
        return this.isBadUnload;
    }
}

