/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.jetty.continuation;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.dynmap.jetty.continuation.Continuation;
import org.dynmap.jetty.continuation.ContinuationSupport;
import org.dynmap.jetty.continuation.ContinuationThrowable;
import org.dynmap.jetty.continuation.FauxContinuation;

public class ContinuationFilter
implements Filter {
    static boolean _initialized;
    static boolean __debug;
    private boolean _faux;
    private boolean _jetty6;
    private boolean _filtered;
    ServletContext _context;
    private boolean _debug;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        boolean jetty_7_or_greater = "org.dynmap.jetty.servlet".equals(filterConfig.getClass().getPackage().getName());
        this._context = filterConfig.getServletContext();
        String param = filterConfig.getInitParameter("debug");
        boolean bl = this._debug = param != null && Boolean.parseBoolean(param);
        if (this._debug) {
            __debug = true;
        }
        if ((param = filterConfig.getInitParameter("jetty6")) == null) {
            param = filterConfig.getInitParameter("partial");
        }
        this._jetty6 = param != null ? Boolean.parseBoolean(param) : ContinuationSupport.__jetty6 && !jetty_7_or_greater;
        param = filterConfig.getInitParameter("faux");
        this._faux = param != null ? Boolean.parseBoolean(param) : !jetty_7_or_greater && !this._jetty6 && this._context.getMajorVersion() < 3;
        boolean bl2 = this._filtered = this._faux || this._jetty6;
        if (this._debug) {
            this._context.log("ContinuationFilter  jetty=" + jetty_7_or_greater + " jetty6=" + this._jetty6 + " faux=" + this._faux + " filtered=" + this._filtered + " servlet3=" + ContinuationSupport.__servlet3);
        }
        _initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this._filtered) {
            FilteredContinuation fc;
            Continuation c = (Continuation)request.getAttribute("org.dynmap.jetty.continuation");
            if (this._faux && (c == null || !(c instanceof FauxContinuation))) {
                fc = new FauxContinuation(request);
                request.setAttribute("org.dynmap.jetty.continuation", fc);
            } else {
                fc = (FilteredContinuation)c;
            }
            boolean complete = false;
            while (!complete) {
                block13: {
                    try {
                        if (fc == null || fc.enter(response)) {
                            chain.doFilter(request, response);
                        }
                        if (fc != null) break block13;
                    }
                    catch (ContinuationThrowable e) {
                        block14: {
                            try {
                                this.debug("faux", e);
                                if (fc != null) break block14;
                            }
                            catch (Throwable throwable) {
                                if (fc == null) {
                                    fc = (FilteredContinuation)request.getAttribute("org.dynmap.jetty.continuation");
                                }
                                complete = fc == null || fc.exit();
                                throw throwable;
                            }
                            fc = (FilteredContinuation)request.getAttribute("org.dynmap.jetty.continuation");
                        }
                        complete = fc == null || fc.exit();
                        continue;
                    }
                    fc = (FilteredContinuation)request.getAttribute("org.dynmap.jetty.continuation");
                }
                complete = fc == null || fc.exit();
            }
        } else {
            try {
                chain.doFilter(request, response);
            }
            catch (ContinuationThrowable e) {
                this.debug("caught", e);
            }
        }
    }

    private void debug(String string) {
        if (this._debug) {
            this._context.log(string);
        }
    }

    private void debug(String string, Throwable th) {
        if (this._debug) {
            if (th instanceof ContinuationThrowable) {
                this._context.log(string + ":" + th);
            } else {
                this._context.log(string, th);
            }
        }
    }

    @Override
    public void destroy() {
    }

    public static interface FilteredContinuation
    extends Continuation {
        public boolean enter(ServletResponse var1);

        public boolean exit();
    }
}

