/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.jetty.server.session;

import java.security.SecureRandom;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.dynmap.jetty.server.SessionIdManager;
import org.dynmap.jetty.util.component.AbstractLifeCycle;
import org.dynmap.jetty.util.log.Log;
import org.dynmap.jetty.util.log.Logger;

public abstract class AbstractSessionIdManager
extends AbstractLifeCycle
implements SessionIdManager {
    private static final Logger LOG = Log.getLogger(AbstractSessionIdManager.class);
    private static final String __NEW_SESSION_ID = "org.dynmap.jetty.server.newSessionId";
    protected Random _random;
    protected boolean _weakRandom;
    protected String _workerName;
    protected long _reseed = 100000L;

    public AbstractSessionIdManager() {
    }

    public AbstractSessionIdManager(Random random) {
        this._random = random;
    }

    public long getReseed() {
        return this._reseed;
    }

    public void setReseed(long reseed) {
        this._reseed = reseed;
    }

    @Override
    public String getWorkerName() {
        return this._workerName;
    }

    public void setWorkerName(String workerName) {
        if (workerName.contains(".")) {
            throw new IllegalArgumentException("Name cannot contain '.'");
        }
        this._workerName = workerName;
    }

    public Random getRandom() {
        return this._random;
    }

    public synchronized void setRandom(Random random) {
        this._random = random;
        this._weakRandom = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String newSessionId(HttpServletRequest request, long created) {
        AbstractSessionIdManager abstractSessionIdManager = this;
        synchronized (abstractSessionIdManager) {
            if (request != null) {
                String cluster_id;
                String requested_id = request.getRequestedSessionId();
                if (requested_id != null && this.idInUse(cluster_id = this.getClusterId(requested_id))) {
                    return cluster_id;
                }
                String new_id = (String)request.getAttribute(__NEW_SESSION_ID);
                if (new_id != null && this.idInUse(new_id)) {
                    return new_id;
                }
            }
            String id = null;
            while (id == null || id.length() == 0 || this.idInUse(id)) {
                long r1;
                long r0;
                long l = r0 = this._weakRandom ? (long)this.hashCode() ^ Runtime.getRuntime().freeMemory() ^ (long)this._random.nextInt() ^ (long)request.hashCode() << 32 : this._random.nextLong();
                if (r0 < 0L) {
                    r0 = -r0;
                }
                if (this._reseed > 0L && r0 % this._reseed == 1L) {
                    LOG.debug("Reseeding {}", this);
                    if (this._random instanceof SecureRandom) {
                        SecureRandom secure = (SecureRandom)this._random;
                        secure.setSeed(secure.generateSeed(8));
                    } else {
                        this._random.setSeed(this._random.nextLong() ^ System.currentTimeMillis() ^ (long)request.hashCode() ^ Runtime.getRuntime().freeMemory());
                    }
                }
                long l2 = r1 = this._weakRandom ? (long)this.hashCode() ^ Runtime.getRuntime().freeMemory() ^ (long)this._random.nextInt() ^ (long)request.hashCode() << 32 : this._random.nextLong();
                if (r1 < 0L) {
                    r1 = -r1;
                }
                id = Long.toString(r0, 36) + Long.toString(r1, 36);
                if (this._workerName == null) continue;
                id = this._workerName + id;
            }
            request.setAttribute(__NEW_SESSION_ID, id);
            return id;
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.initRandom();
    }

    @Override
    protected void doStop() throws Exception {
    }

    public void initRandom() {
        if (this._random == null) {
            try {
                this._random = new SecureRandom();
            }
            catch (Exception e) {
                LOG.warn("Could not generate SecureRandom for session-id randomness", e);
                this._random = new Random();
                this._weakRandom = true;
            }
        } else {
            this._random.setSeed(this._random.nextLong() ^ System.currentTimeMillis() ^ (long)this.hashCode() ^ Runtime.getRuntime().freeMemory());
        }
    }
}

